/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.ui.bonsai.table;

import com.ibm.hwmca.fw.servlet.util.HMCSession;
import com.ibm.hwmca.fw.util.Trace;
import com.ibm.hwmca.ui.bonsai.earth.TaskNode;
import com.ibm.hwmca.ui.bonsai.servlet.util.UserObject;
import com.ibm.hwmca.ui.bonsai.table.ImageWithHyperlinkCell;
import com.ibm.hwmca.ui.bonsai.table.NameTableCellBean;
import com.ibm.hwmca.ui.bonsai.util.GraphicsConstants;
import com.ibm.psw.wcl.components.menu.IMenuItem;
import com.ibm.psw.wcl.components.menu.MenuInfo;
import com.ibm.psw.wcl.components.menu.MenuItemInfo;
import com.ibm.psw.wcl.components.menu.WPopupMenu;
import com.ibm.psw.wcl.components.table.WTable;
import com.ibm.psw.wcl.core.RenderingContext;
import com.ibm.psw.wcl.core.WComponent;
import com.ibm.psw.wcl.core.cell.AWCell;
import com.ibm.psw.wcl.core.cell.CellInfo;
import com.ibm.psw.wcl.core.markup.WHyperlink;
import com.ibm.psw.wcl.core.markup.WImage;
import com.ibm.psw.wcl.core.renderer.RendererException;
import com.ibm.psw.wcl.core.renderer.output.IOutput;
import com.ibm.psw.wcl.core.skin.AStyleInfo;
import com.ibm.psw.wcl.renderers.cell.html.HTMLDefaultCellRenderer;
import com.ibm.psw.wcl.skins.base.BaseHyperlinkStyleInfo;
import java.util.Iterator;
import java.util.List;

public class SystemManagementNameCellRenderer
extends HTMLDefaultCellRenderer {
    private static final String TRACEMASK_T = "XBUISNRT";
    private static final String TRACEMASK_F = "XBUISNRF";
    private static final String TRACEMASK_D = "XBUISNRD";

    public IOutput renderCell(RenderingContext rc, AWCell cell, CellInfo info) throws RendererException {
        if (cell instanceof ImageWithHyperlinkCell) {
            return this.prepareCell(rc, (ImageWithHyperlinkCell)cell, info);
        }
        return super.renderCell(rc, cell, info);
    }

    public IOutput prepareCell(RenderingContext rc, ImageWithHyperlinkCell cell, CellInfo cellInfo) throws RendererException {
        HMCSession hmcSession;
        UserObject userObj;
        List lTaskNodes;
        Trace.trace(TRACEMASK_D, "-> SystemTableCellRenderer.prepareCell()");
        NameTableCellBean cellBean = (NameTableCellBean)cellInfo.getValue();
        if (cellBean == null) {
            return cell.getOutput(rc);
        }
        cell.getHyperlink().setStyleInfo(null);
        AStyleInfo hyperlinkStyle = cell.getHyperlink().getStyleInfo(rc.getSkin());
        if (hyperlinkStyle == null) {
            hyperlinkStyle = new BaseHyperlinkStyleInfo();
            cell.getHyperlink().setStyleInfo(hyperlinkStyle);
        }
        cell.setText(cellBean.getText());
        String imageUrl = null;
        imageUrl = cellBean.isBusy() ? GraphicsConstants.getBusyIcon() : (cellBean.isLocked() ? GraphicsConstants.getLockedIcon() : cellBean.getImageUrl());
        if (imageUrl != null) {
            WImage anImage = cell.getImage();
            anImage.setURL(imageUrl);
            cell.setImage(anImage);
        }
        String linkUrl = cellBean.getUrl();
        WHyperlink link = cell.getHyperlink();
        if (linkUrl != null) {
            link.setURL(linkUrl);
            link.setTarget(cellBean.getUrlTarget());
            link.setEnabled(true);
        } else {
            hyperlinkStyle.setStyleValue("lnk1", "color", (Object)"#000000");
            link.setEnabled(false);
        }
        WPopupMenu wPopupMenu = null;
        if (cellInfo.getSelected() && (lTaskNodes = (userObj = UserObject.getUserObject(hmcSession = HMCSession.getHMCSession(rc.getSession(false)))).getResourceTaskTrees()) != null && !lTaskNodes.isEmpty()) {
            MenuInfo root = new MenuInfo();
            this.buildMenuItems(root, lTaskNodes);
            if (root.getChildCount() > 0) {
                wPopupMenu = new WPopupMenu((IMenuItem)root);
                wPopupMenu.setID(cellBean.getId());
                wPopupMenu.setVisible(true);
                cell.add((WComponent)wPopupMenu);
            }
        }
        hyperlinkStyle.setStyleValue("lnk1", "font-size", (Object)"smaller");
        cell.setStyleInfo(hyperlinkStyle);
        IOutput iOutput = cell.getOutput(rc);
        if (cellInfo.getSelected() && wPopupMenu != null) {
            cell.remove((WComponent)wPopupMenu);
        }
        return iOutput;
    }

    private void buildMenuItems(MenuInfo root, List lTaskNodes) {
        TaskNode tNode = null;
        MenuInfo group = null;
        MenuItemInfo mi = null;
        Iterator iter = lTaskNodes.iterator();
        while (iter.hasNext()) {
            tNode = (TaskNode)iter.next();
            String name = tNode.getName().replace('\n', ' ');
            if (!tNode.isTask()) {
                group = new MenuInfo(name);
                root.addChild((IMenuItem)group);
                this.buildMenuItems(group, tNode.getChildren());
                continue;
            }
            mi = new MenuItemInfo();
            mi.setText(name);
            mi.setOnClick("document.location.href = '" + tNode.getUrlString() + "'");
            root.addChild((IMenuItem)mi);
        }
    }

    private boolean isSingleRowSelected(CellInfo cellInfo) {
        boolean selected = ((WTable)cellInfo.getOwnerComponent()).getModel().getSelectedModelRowCount() == 1;
        return true;
    }
}

